/*
 * Decompiled with CFR 0.152.
 */
package com.renyigesai.immortalers_delight.block.food;

import com.google.common.collect.ImmutableList;
import com.renyigesai.immortalers_delight.block.brushable.ModBrushableBlockEntity;
import com.renyigesai.immortalers_delight.block.brushable.SuspiciousAshPileBlock;
import com.renyigesai.immortalers_delight.init.ImmortalersDelightBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeHooks;

public class NaanBakingPitBlock
extends HorizontalDirectionalBlock {
    private static final Iterable<Vec3> PARTICLE_OFFSETS = ImmutableList.of((Object)new Vec3(0.5, 1.0, 0.5));
    public static final BooleanProperty PERSISTENT = BlockStateProperties.f_61447_;
    public static final BooleanProperty LIT = BlockStateProperties.f_61443_;
    public static final VoxelShape BOX = NaanBakingPitBlock.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)4.0, (double)14.0);
    public static final VoxelShape BOX_LIT = NaanBakingPitBlock.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)10.0, (double)15.0);
    public static final VoxelShape OUTLINE_BOX = NaanBakingPitBlock.m_49796_((double)1.9, (double)0.0, (double)1.9, (double)14.1, (double)4.2, (double)14.1);
    public static final VoxelShape OUTLINE_BOX_LIT = NaanBakingPitBlock.m_49796_((double)0.1, (double)0.0, (double)0.1, (double)15.9, (double)12.0, (double)15.9);

    public NaanBakingPitBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        super.m_49959_((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)Direction.NORTH)).m_61124_((Property)PERSISTENT, (Comparable)Boolean.valueOf(false))).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(true)));
    }

    public void m_7892_(BlockState pState, Level pLevel, BlockPos pPos, Entity pEntity) {
        if (!pLevel.f_46443_ && ((Boolean)pState.m_61143_((Property)LIT)).booleanValue()) {
            pEntity.m_6469_(pEntity.m_269291_().m_269047_(), 1.1f);
            pEntity.m_20254_(8);
        }
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        ItemStack itemstack;
        if (!((Boolean)pState.m_61143_((Property)LIT)).booleanValue() && (itemstack = pPlayer.m_21120_(pHand)).m_41720_() == Items.f_42258_) {
            pLevel.m_46597_(pPos, (BlockState)pState.m_61124_((Property)LIT, (Comparable)Boolean.valueOf(true)));
            if (!pPlayer.m_7500_()) {
                itemstack.m_41774_(1);
            }
            return InteractionResult.m_19078_((boolean)pLevel.f_46443_);
        }
        return super.m_6227_(pState, pLevel, pPos, pPlayer, pHand, pHit);
    }

    public boolean m_6724_(BlockState p_54449_) {
        return (Boolean)p_54449_.m_61143_((Property)LIT) != false && (Boolean)p_54449_.m_61143_((Property)PERSISTENT) == false;
    }

    public void m_213898_(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        if (!pLevel.isAreaLoaded(pPos, 1)) {
            return;
        }
        if (ForgeHooks.onCropsGrowPre((Level)pLevel, (BlockPos)pPos, (BlockState)pState, (pRandom.m_188503_(3) == 0 ? 1 : 0) != 0)) {
            pLevel.m_46597_(pPos, (BlockState)((Block)ImmortalersDelightBlocks.SUSPICIOUS_ASH_PILE.get()).m_49966_().m_61124_((Property)SuspiciousAshPileBlock.FACING, (Comparable)((Direction)pState.m_61143_((Property)f_54117_))));
            CompoundTag blockEntityTag = new CompoundTag();
            blockEntityTag.m_128359_("LootTable", "immortalers_delight:archaeology/naan_baking_pit");
            blockEntityTag.m_128356_("LootTableSeed", pLevel.m_213780_().m_188505_());
            BlockEntity blockEntity = pLevel.m_7702_(pPos);
            if (blockEntity instanceof ModBrushableBlockEntity) {
                ModBrushableBlockEntity blockEntity2 = (ModBrushableBlockEntity)blockEntity;
                blockEntity2.m_142466_(blockEntityTag);
                blockEntity2.m_6596_();
            }
            ForgeHooks.onCropsGrowPost((Level)pLevel, (BlockPos)pPos, (BlockState)pState);
        }
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        return (Boolean)state.m_61143_((Property)LIT) != false ? OUTLINE_BOX_LIT : OUTLINE_BOX;
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        return (Boolean)state.m_61143_((Property)LIT) != false ? BOX_LIT : BOX;
    }

    public BlockState m_5573_(BlockPlaceContext pContext) {
        if (!pContext.m_43722_().m_41720_().m_5524_().equals(this.m_7705_())) {
            return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)pContext.m_8125_())).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false));
        }
        return (BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)pContext.m_8125_());
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        return facing == Direction.DOWN && !stateIn.m_60710_((LevelReader)level, currentPos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(stateIn, facing, facingState, level, currentPos, facingPos);
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        return level.m_8055_(pos.m_7495_()).m_280296_();
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_54117_}).m_61104_(new Property[]{PERSISTENT}).m_61104_(new Property[]{LIT});
    }

    public void m_214162_(BlockState pState, Level pLevel, BlockPos pPos, RandomSource pRandom) {
        if (((Boolean)pState.m_61143_((Property)LIT)).booleanValue()) {
            this.getParticleOffsets(pState).forEach(p_220695_ -> NaanBakingPitBlock.addParticlesAndSound(pLevel, p_220695_.m_82520_((double)pPos.m_123341_(), (double)pPos.m_123342_(), (double)pPos.m_123343_()), pRandom));
        }
    }

    protected Iterable<Vec3> getParticleOffsets(BlockState pState) {
        return PARTICLE_OFFSETS;
    }

    private static void addParticlesAndSound(Level pLevel, Vec3 pOffset, RandomSource pRandom) {
        float f = pRandom.m_188501_();
        if (f < 0.3f) {
            pLevel.m_7106_((ParticleOptions)ParticleTypes.f_123762_, pOffset.f_82479_, pOffset.f_82480_, pOffset.f_82481_, 0.0, 0.0, 0.0);
            if (f < 0.17f) {
                pLevel.m_7785_(pOffset.f_82479_ + 0.5, pOffset.f_82480_ + 0.5, pOffset.f_82481_ + 0.5, SoundEvents.f_144096_, SoundSource.BLOCKS, 1.0f + pRandom.m_188501_(), pRandom.m_188501_() * 0.7f + 0.3f, false);
            }
        }
        pLevel.m_7106_((ParticleOptions)ParticleTypes.f_175834_, pOffset.f_82479_, pOffset.f_82480_, pOffset.f_82481_, 0.0, 0.0, 0.0);
    }
}

